# BSP: ESP32-P4 Function EV Board

[![Component Registry](https://components.espressif.com/components/espressif/esp32_p4_function_ev_board/badge.svg)](https://components.espressif.com/components/espressif/esp32_p4_function_ev_board)

ESP32-P4 Function EV Board is internal Espressif board for testing features on ESP32P4 chip.

| HW version | BSP Version |
| :--------: | :---------: |
|    V1.0    |      ^1     |
|    V1.2    |      ^2     |
|    [V1.4](https://docs.espressif.com/projects/esp-dev-kits/en/latest/esp32p4/esp32-p4-function-ev-board/user_guide.html)    |      ^3     |

## Configuration

Configuration in `menuconfig`.

Selection LCD display `Board Support Package(ESP32-P4) --> Display --> Select LCD type`
- LCD 7-inch 1280x800 - ili9881c (default)
- LCD 1024x600 - ek79007

Selection color format `Board Support Package(ESP32-P4) --> Display --> Select LCD color format`
- RGB565 (default)
- RGB888


<!-- Autogenerated start: Dependencies -->
### Capabilities and dependencies
|  Capability |     Available    |                                                 Component                                                |Version|
|-------------|------------------|----------------------------------------------------------------------------------------------------------|-------|
|   DISPLAY   |:heavy_check_mark:|    [espressif/esp_lcd_ek79007](https://components.espressif.com/components/espressif/esp_lcd_ek79007)    |  1.*  |
|  LVGL_PORT  |:heavy_check_mark:|      [espressif/esp_lvgl_port](https://components.espressif.com/components/espressif/esp_lvgl_port)      |   ^2  |
|    TOUCH    |:heavy_check_mark:|[espressif/esp_lcd_touch_gt911](https://components.espressif.com/components/espressif/esp_lcd_touch_gt911)|   ^1  |
|   BUTTONS   |        :x:       |                                                                                                          |       |
|    AUDIO    |:heavy_check_mark:|      [espressif/esp_codec_dev](https://components.espressif.com/components/espressif/esp_codec_dev)      | 1.2.* |
|AUDIO_SPEAKER|:heavy_check_mark:|                                                                                                          |       |
|  AUDIO_MIC  |:heavy_check_mark:|                                                                                                          |       |
|    SDCARD   |:heavy_check_mark:|                                                    idf                                                   | >=5.3 |
|     IMU     |        :x:       |                                                                                                          |       |
<!-- Autogenerated end: Dependencies -->
