/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "bf3925_regs.h"
#include "bf3925_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define BF3925_SPEC_EFFECT_REG_SIZE (10)

static const bf3925_reginfo_t bf3925_spec_effect_regs[6][BF3925_SPEC_EFFECT_REG_SIZE] = {
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x10},
        {0x52, 0x02},
        {0x5e, 0x80},
        {0x5f, 0x80},
        {BF3925_REG_DELAY, 0x01},
        {BF3925_REG_DELAY, 0x01},
    }, /*ENC_NORMAL*/
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x10},
        {0x52, 0x06},
        {0x5e, 0x80},
        {0x5f, 0x80},
        {0x38, 0x40},
        {BF3925_REG_DELAY, 0x01},
    }, /*ENC_GRAYSCALE*/
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x10},
        {0x52, 0x06},
        {0x5e, 0x60},
        {0x5f, 0xa0},
        {0x38, 0x40},
        {BF3925_REG_DELAY, 0x01},
    }, /*ENC_SEPIA*/
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x10},
        {0x52, 0x06},
        {0x5e, 0x60},
        {0x5f, 0x70},
        {0x01, 0x05},
        {0x38, 0x40},
    }, /*ENC_SEPIAGREEN*/
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x10},
        {0x52, 0x06},
        {0x5e, 0xe0},
        {0x5f, 0x60},
        {0x01, 0x05},
        {0x38, 0x40},
    }, /*ENC_SEPIABLUE*/
    {
        {0x80, 0x0f},
        {0xd6, 0x61},
        {0xff, 0x01},
        {0x32, 0xd0},
        {0x50, 0x18},
        {0x52, 0x02},
        {0x5e, 0x80},
        {0x5f, 0x80},
        {0x01, 0x05},
        {0x38, 0x40},
    }, /*ENC_COLORINV*/
};

static const bf3925_reginfo_t DVP_8bit_20Minput_1600x1200_yuv422_9fps[] = {
    {0xff, 0x01},  //Bit[0]: select reg page
    {0x50, 0x10},  //bit[4]: digital subsample  bit[2][0]: Data format selection
    {0x51, 0x02},  //YUV Sequence
    {0xe0, 0x00},
    {0xe2, 0x64},
    {0xe3, 0x48},
    {0xe4, 0x81},  //Drive capability
    {0xe7, 0x9b},

    //clock，dummy
    {0xff, 0x01},  //Bit[0]: select reg page
    {0xe9, 0x2a},  //PLL setting  0x09: 1倍频   0x1b: 5/4倍频   0x2b: 3/2倍频  0x08: 2倍频  0x1a: 5/2倍频  0x2a: 3倍频
    {0xff, 0x00},  //Bit[0]: select reg page
    {0x01, 0x00},
    {0x02, 0x90},  //Dummy Pixel Insert LSB
    {0x03, 0x02},
    {0x04, 0x00},  //Dummy line Insert LSB
    {0xff, 0x01},
    {0xe5, 0x32},

    //resolution:1600x1200
    {0xff, 0x00},
    {0x05, 0xA8},
    {0x09, 0x04},
    {0x0a, 0x4C},
    {0x0b, 0x60},
    {0x0c, 0x04},
    {0x0d, 0xBC},
    {0x0e, 0x40},
    {0xff, 0x01},
    {0xe9, 0x2a},
    {0x53, 0x60},
    {0x54, 0x40},
    {0x55, 0x02},
    {0x56, 0x42},
    {0x57, 0x01},
    {0x58, 0xB1},
    {0x50, 0x00},
    {0x0c, 0xA1},
    {0x0d, 0x86},
    {0x5d, 0x02},
    {0x5a, 0x00},
    {0x5b, 0x00},
    {0x5c, 0x00},

    //initial AWB and AE
    {0xff, 0x00},  //Bit[0]: select reg page
    {0xb2, 0x81},  //Manual AWB & AE
    {0xb0, 0x16},
    {0xb1, 0x1d},
    {0xb2, 0x89},
    {0xff, 0x01},
    {0x00, 0x00},
    {0x0e, 0x0a},
    {0x0f, 0x64},
    {0x10, 0x28},
    {0x00, 0x05},

    //black control
    {0xff, 0x00},
    {0x3c, 0x97},

    //black sun
    {0xff, 0x01},  //Bit[0]: select reg page
    {0xe1, 0x28},  //bit[7:4]: Pixel bias current
    {0xff, 0x00},  //Bit[0]: select reg page
    {0x00, 0x47},  //bit[6]: black sun control   bit[5]: mirror   bit[4]: vertical flip
    {0x18, 0x0c},  //PRST indoor
    {0x19, 0x1a},  //PRST outdoor

    //lens shading
    {0xff, 0x00},  //Bit[0]: select reg page
    {0x52, 0x13},
    {0x53, 0x5c},
    {0x54, 0x24},
    {0x55, 0x13},
    {0x56, 0x5c},
    {0x57, 0x24},
    {0x58, 0xd3},
    {0x59, 0x5c},
    {0x5a, 0x24},
    {0x5b, 0x46}, //lens shading gain of R
    {0x5c, 0x43}, //lens shading gain of G1
    {0x5d, 0x40}, //lens shading gain of B
    {0x5e, 0x43}, //lens shading gain of G0

    //gamma default
    {0xff, 0x00}, //Bit[0]: select reg page
    {0x60, 0x30},
    {0x61, 0x2a},
    {0x62, 0x24},
    {0x63, 0x1b},
    {0x64, 0x18},
    {0x65, 0x16},
    {0x66, 0x14},
    {0x67, 0x12},
    {0x68, 0x10},
    {0x69, 0x0e},
    {0x6a, 0x0d},
    {0x6b, 0x0c},
    {0x6c, 0x0a},
    {0x6d, 0x09},
    {0x6e, 0x09},

    {0x6f, 0xf0},
    {0x70, 0x20},
    {0x71, 0x60},

    {0x72, 0x20},
    {0x73, 0x20},


    /*
    //gamma 过曝过度好，高亮
        {0xff, 0x00},    //Bit[0]: select reg page
        {0x60, 0x33},
        {0x61, 0x2b},
        {0x62, 0x27},
        {0x63, 0x22},
        {0x64, 0x1b},
        {0x65, 0x17},
        {0x66, 0x14},
        {0x67, 0x11},
        {0x68, 0x0e},
        {0x69, 0x0c},
        {0x6a, 0x0b},
        {0x6b, 0x0a},
        {0x6c, 0x09},
        {0x6d, 0x08},
        {0x6e, 0x07},

    //gamma 清晰亮丽
        {0xff, 0x00}, //Bit[0]: select reg page
        {0x60, 0x28},
        {0x61, 0x28},
        {0x62, 0x26},
        {0x63, 0x22},
        {0x64, 0x1f},
        {0x65, 0x1c},
        {0x66, 0x18},
        {0x67, 0x13},
        {0x68, 0x10},
        {0x69, 0x0d},
        {0x6a, 0x0c},
        {0x6b, 0x0a},
        {0x6c, 0x08},
        {0x6d, 0x07},
        {0x6e, 0x06},

    //gamma low denoise
        {0xff, 0x00}, //Bit[0]: select reg page
        {0x60, 0x24},
        {0x61, 0x30},
        {0x62, 0x20},
        {0x63, 0x1a},
        {0x64, 0x16},
        {0x65, 0x13},
        {0x66, 0x11},
        {0x67, 0x0e},
        {0x68, 0x0d},
        {0x69, 0x0c},
        {0x6a, 0x0b},
        {0x6b, 0x09},
        {0x6c, 0x09},
        {0x6d, 0x08},
        {0x6e, 0x07},*/
    /*
    //gamma more details under low light,light enough
    {0x60, 0x50},
    {0x61, 0x40},
    {0x62, 0x28},
    {0x63, 0x20},
    {0x64, 0x18},
    {0x65, 0x16},
    {0x66, 0x12},
    {0x67, 0x10},
    {0x68, 0x0d},
    {0x69, 0x0b},
    {0x6a, 0x09},
    {0x6b, 0x08},
    {0x6c, 0x07},
    {0x6d, 0x04},
    {0x6e, 0x02},
    {0x6a, 0x0a},
    {0x6b, 0x08},
    {0x6c, 0x04},
    {0x6d, 0x02},
    {0x6e, 0x01},
    */
    //new default gamma
    {0xff, 0x00}, //Bit[0]: select reg page
    {0x60, 0x30},
    {0x61, 0x2a},
    {0x62, 0x24},
    {0x63, 0x1a},
    {0x64, 0x1a},
    {0x65, 0x18},
    {0x66, 0x16},
    {0x67, 0x14},
    {0x68, 0x10},
    {0x69, 0x0e},
    {0x6a, 0x0d},
    {0x6b, 0x0a},
    {0x6c, 0x06},
    {0x6d, 0x04},
    {0x6e, 0x02},

    {0x93, 0x0a},  //0x93[4:0]值越小，噪声越小，边缘越模糊0x0c

    //denoise and edge enhancement
    {0xff, 0x00}, //Bit[0]: select reg page
    {0x80, 0x0f},
    {0x81, 0x1c},//0x0c zhouji
    {0x83, 0x27}, //0x83[7:4]: The bigger, the smaller noise; 0x83[3:0]: The smaller, the smaller noise
    {0x84, 0xe6},
    {0x85, 0x88},
    {0x86, 0xfa},
    {0x87, 0x1a},
    {0x88, 0xa2},  //bit[7]和[6]设置为0噪声小
    {0x89, 0xca},
    {0x8b, 0x12}, //0x8b[7:4]: Bright edge enhancement; 0x8b[3:0]: Dark edge enhancement
    {0x91, 0x45},  //91写40，噪声大，清晰

    //AWB
    {0xff, 0x00}, //Bit[0]: select reg page
    {0xa2, 0x06},  //the low limit of blue gain for indoor scene
    {0xa3, 0x28},  //the upper limit of blue gain for indoor scene
    {0xa4, 0x0a},  //the low limit of red gain for indoor scene
    {0xa5, 0x2c},  //the upper limit of red gain for indoor scene
    {0xa7, 0x1b},  //Base B gain不建议修改
    {0xa8, 0x14},  //Base R gain不建议修改
    {0xa9, 0x15},
    {0xaa, 0x18},
    {0xab, 0x26},
    {0xac, 0x5c},
    {0xae, 0x47},
    {0xb2, 0x89},
    {0xb3, 0x66},  // green gain
    {0xb4, 0x03},  //the offset of F light
    {0xb5, 0x00},  //the offset of non-F light
    {0xb6, 0xd9},  //bit[7]: outdoor control
    {0xb8, 0xca},
    {0xbb, 0x0d},
    {0xbc, 0x15},
    {0xbd, 0x09},
    {0xbe, 0x24},
    {0xbf, 0x66},

    // color default
    {0xff, 0x00}, //Bit[0]: select reg page
    {0xc0, 0x8a},
    {0xc1, 0x05},
    {0xc2, 0x84},
    {0xc3, 0x86},
    {0xc4, 0x03},
    {0xc5, 0x93},

    /*
    //color 艳丽
        {0xff, 0x00}, //Bit[0]: select reg page
        {0xc0, 0x83},
        {0xc1, 0x86},
        {0xc2, 0x82},
        {0xc3, 0x8a},
        {0xc4, 0x07},
        {0xc5, 0x9f},

    //color 色彩淡
        {0xff, 0x00}, //Bit[0]: select reg page
        {0xc0, 0x83},
        {0xc1, 0x02},
        {0xc2, 0x84},
        {0xc3, 0x84},
        {0xc4, 0x03},
        {0xc5, 0x8d},  */

    // A color
    {0xff, 0x00}, //Bit[0]: select reg page
    {0xc6, 0x8a},
    {0xc7, 0x82},
    {0xc8, 0x8b},
    {0xc9, 0x87},
    {0xca, 0x83},
    {0xcb, 0x91},

    //Outdoor color
    {0xff, 0x00}, //Bit[0]: select reg page
    {0xd0, 0x90},
    {0xd1, 0x05},
    {0xd2, 0x82},
    {0xd3, 0x88},
    {0xd4, 0x03},
    {0xd5, 0x93},

    {0xcd, 0x30},
    {0xd6, 0x61},

    //AE
    {0xff, 0x01}, //Bit[0]: select reg page
    {0x00, 0x05},
    {0x01, 0x8a}, // AE 窗口和权重
    {0x04, 0x45}, // AE Target
    {0x05, 0x45}, // Y target value1
    {0x07, 0x92}, //Bit[3:2]: the bigger, Y_AVER_MODIFY is smaller
    {0x09, 0x8c}, //Bit[5:0]: INT_MAX
    {0x0b, 0x82}, //Bit[5:0]: INT_MIN
    {0x0c, 0x78}, //50hz banding//be
    {0x0d, 0x64}, //60hz banding//a0
    {0x15, 0x42}, //Bit[7:4]: Threshold for over exposure pixels, the smaller, the more over exposure pixels; Bit[3:0]: Control the start of AE
    {0x17, 0xb5},
    {0x18, 0x30},
    {0x19, 0x9a},//added by zhouji
    {0x1b, 0x33}, //minimum global gain
    {0x1c, 0x66},
    {0x1d, 0x55},
    {0x1e, 0x80},
    {0x1f, 0xc0}, //maximum gain

    // saturation
    {0xff, 0x01}, //Bit[0]: select reg page
    {0x30, 0xe0},
    {0x31, 0x48},
    {0x32, 0xf0},
    {0x34, 0xda},  //Cb Saturation Coefficient low 8 bit for NF light
    {0x35, 0xca},  //Cr Saturation Coefficient low 8 bit for NF light
    {0x36, 0xff},  //Cb Saturation Coefficient low 8 bit for F light
    {0x37, 0xd0},  //Cr Saturation Coefficient low 8 bit for F light

    //skin
    {0xff, 0x01}, //Bit[0]: select reg page
    {0x3b, 0x08},

    // auto contrast
    {0xff, 0x01}, //Bit[0]: select reg page
    {0x3e, 0x02}, //不建议调整
};

#ifdef __cplusplus
}
#endif
