/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "ov2710_regs.h"
#include "ov2710_types.h"

#define BIT(nr)                                    (1UL << (nr))

/* MCLK:24MHz  1920x1080  30fps   mipi 1lane   800Mbps/lane V4L2_MBUS_FMT_SBGGR10_1X10 */
static const ov2710_reginfo_t init_reglist_MIPI_1lane_1920_1080_30fps[] = {
    {0x3008, 0x82}, // reset
    {OV2710_REG_DELAY, 0x04},
    {0x4800, BIT(0)},// Ensure streaming off to make `clock lane` go into LP-11 state.
    {0x3008, 0x42}, // sleep en
    {OV2710_REG_DELAY, 0x04},
    {0x4201, 0x00},
    {0x4202, 0x0f},
    {0x3103, 0x93}, // PLL Clock select
    {0x3017, 0x7f},
    {0x3018, 0xfc},
    {0x3706, 0x61},
    {0x3712, 0x0c},
    {0x3630, 0x6d},
    {0x3800, 0x01}, // HREF Horizontal start point
    {0x3801, 0xb4},
    {0x3802, 0x00},
    {0x3803, 0x0a},
    {0x3818, 0x80},
    {0x3804, 0x07},
    {0x3805, 0x80},
    {0x3806, 0x04},
    {0x3807, 0x38},
    {0x3808, 0x07},
    {0x3809, 0x80},
    {0x380a, 0x04},
    {0x380b, 0x38},
    {0x3810, 0x10},
    {0x3811, 0x06},
    {0x3812, 0x00},
    {0x3813, 0x00},
    {0x3621, 0x04},
    {0x3604, 0x60},
    {0x3603, 0xa7},
    {0x3631, 0x26},
    {0x3600, 0x04},
    {0x3620, 0x37},
    {0x3623, 0x00},
    {0x3702, 0x9e},
    {0x3703, 0x5c},
    {0x3704, 0x40},
    {0x370d, 0x0f},
    {0x3713, 0x9f},
    {0x3714, 0x4c},
    {0x3710, 0x9e},
    {0x3801, 0xc4},
    {0x3605, 0x05},
    {0x3606, 0x3f},
    {0x302d, 0x90},
    {0x370b, 0x40},
    {0x3716, 0x31},
    {0x3707, 0x52},
    {0x380d, 0x74},
    {0x5181, 0x20},
    {0x518f, 0x00},
    {0x4301, 0xff},
    {0x4303, 0x00},
    {0x3a00, 0x78},
    {0x300f, 0x88},
    {0x3011, 0x28},
    {0x3a1a, 0x06},
    {0x3a18, 0x00},
    {0x3a19, 0x7a},
    {0x3a13, 0x54},
    {0x382e, 0x0f},
    {0x381a, 0x1a},
    {0x401d, 0x02},// always update blc
    {0x5688, 0x03},
    {0x5684, 0x07},// avg vertical set
    {0x5685, 0xa0},
    {0x5686, 0x04},
    {0x5687, 0x43},
    {0x3011, 0x0a},
    {0x300f, 0x8a},
    {0x3017, 0x00},
    {0x3018, 0x00},
    {0x300e, 0x04},
    {0x4801, 0x0f},
    {0x300f, 0xc3},
    {0x3a0f, 0x40}, // AEC control, AE target
    {0x3a10, 0x38},
    {0x3a1b, 0x48},
    {0x3a1e, 0x30},
    {0x3a11, 0x90},
    {0x3a1f, 0x10},
    {0x380c, 0x09},/*HTS H*/
    {0x380d, 0x74},/*HTS L*/
    {0x380e, 0x04},/*VTS H*/
    {0x380f, 0x50},/*VTS L*/
    {0x4800, 0x24}, // 0x14? 0x00? CONFIG_CAMERA_CSI_LINESYNC_ENABLE ? 0x14 : 0x00
    {OV2710_REG_DELAY, 0x02},
    {OV2710_REG_END, 0x00},
};

static const ov2710_reginfo_t init_reglist_MIPI_1lane_1280_720_60fps[] = {
    {0x3103, 0x93},
    {0x3008, 0x82}, // reset
    {OV2710_REG_DELAY, 0x04},
    {0x4800, BIT(0)},// Ensure streaming off to make `clock lane` go into LP-11 state.
    {0x3008, 0x42}, // sleep en
    {OV2710_REG_DELAY, 0x04},

    {0x3103, 0x93},
    {0x3017, 0x00}, // pad output enable01  0-input 1-output
    {0x3018, 0x00}, // pad output enable02  0-input 1-output
    {0x3706, 0x61},
    {0x3712, 0x0c},
    {0x3630, 0x6d},
    {0x3801, 0xb4},
    {0x3621, 0x04},
    {0x3604, 0x60},
    {0x3603, 0xa7},
    {0x3631, 0x26},
    {0x3600, 0x04},
    {0x3620, 0x37},
    {0x3623, 0x00},
    {0x3702, 0x9e},
    {0x3703, 0x5c},
    {0x3704, 0x40},
    {0x370d, 0x0f},
    {0x3713, 0x9f},
    {0x3714, 0x4c},
    {0x3710, 0x9e},
    {0x3801, 0xc4},
    {0x3605, 0x05},
    {0x3606, 0x3f},
    {0x302d, 0x90},
    {0x370b, 0x40},
    {0x3716, 0x31},
    {0x3707, 0x52},
    {0x380d, 0x74},
    {0x5181, 0x20},
    {0x518f, 0x00},
    {0x4301, 0xff},
    {0x4303, 0x00},
    //turn of night mode 3a00[2]->0
    {0x3a00, 0x78},
    {0x300f, 0x88},
    {0x3011, 0x28},
    {0x3a1a, 0x06},
    {0x3a18, 0x00},
    {0x3a19, 0x7a},
    {0x3a13, 0x54},
    {0x382e, 0x0f},
    {0x381a, 0x1a},
    {0x401d, 0x02},
    {0x381c, 0x10},
    {0x381d, 0xb8},
    {0x381e, 0x02},
    {0x381f, 0xdc},
    {0x3820, 0x0a},
    {0x3821, 0x29},
    {0x3804, 0x05},
    {0x3805, 0x00},
    {0x3806, 0x02},
    {0x3807, 0xd0},
    {0x3808, 0x05},
    {0x3809, 0x00},
    {0x380a, 0x02},
    {0x380b, 0xd0},
    {0x380e, 0x02},
    {0x380f, 0xe8},
    {0x380c, 0x07},
    {0x380d, 0x00},
    {0x5688, 0x03},
    {0x5684, 0x05},
    {0x5685, 0x00},
    {0x5686, 0x02},
    {0x5687, 0xd0},
    //50hz band
    {0x3a08, 0x1b},
    {0x3a09, 0xe6},
    //60hz band
    {0x3a0a, 0x17},
    {0x3a0b, 0x40},
    {0x3a0e, 0x01},
    {0x3a0d, 0x02},
    {0x3011, 0x0a},
    {0x300f, 0xc3},

    {0x300e, 0x04},
    {0x4801, 0x0f},
    {0x4800, 0x24},
    {OV2710_REG_END, 0x00},
};

#ifdef __cplusplus
}
#endif
