/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "sc035hgs_regs.h"
#include "sc035hgs_types.h"

#ifdef __cplusplus
extern "C" {
#endif

//Cleaned_0x18_SC035HGS_MIPI_20Minput_1lane_10bit_500Mbps_640x480_48.050fps
static const sc035hgs_reginfo_t mipi_20Minput_1lane_640x480_raw10_48fps[] = {
    {0x0103, 0x01},
    {SC035HGS_REG_DELAY, 0x08},
    {SC035HGS_REG_SLEEP_MODE, 0x00}, // sleep en
    {0x36e9, 0x80},
    {0x36f9, 0x80},
    {0x3000, 0x00},
    {0x3001, 0x00},
    {0x300f, 0x0f},
    {0x3018, 0x13},
    {0x3019, 0xfe},
    {0x301c, 0x78},
    {0x301f, 0x18},
    {0x3031, 0x0a},
    {0x3037, 0x20},
    {0x303f, 0x01},
    {0x320c, 0x04},
    {0x320d, 0x70},
    {0x320e, 0x03},
    {0x320f, 0x94},
    {0x3217, 0x00},
    {0x3218, 0x00},
    {0x3220, 0x10},
    {0x3223, 0x48},
    {0x3226, 0x74},
    {0x3227, 0x07},
    {0x323b, 0x00},
    {0x3250, 0xf0},
    {0x3251, 0x02},
    {0x3252, 0x03},
    {0x3253, 0x8c},
    {0x3254, 0x02},
    {0x3255, 0x07},
    {0x3304, 0x48},
    {0x3305, 0x00},
    {0x3306, 0x98},
    {0x3309, 0x50},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x18},
    {0x330f, 0x40},
    {0x3310, 0x10},
    {0x3314, 0x6d},
    {0x3315, 0x30},
    {0x3316, 0x68},
    {0x3317, 0x13},
    {0x3329, 0x5c},
    {0x332d, 0x5c},
    {0x332f, 0x60},
    {0x3335, 0x64},
    {0x3344, 0x64},
    {0x335b, 0x80},
    {0x335f, 0x80},
    {0x3366, 0x06},
    {0x3385, 0x41},
    {0x3387, 0x49},
    {0x3389, 0x01},
    {0x33b1, 0x03},
    {0x33b2, 0x06},
    {0x33bd, 0xe0},
    {0x33bf, 0x10},
    {0x3621, 0xa4},
    {0x3622, 0x05},
    {0x3624, 0x47},
    {0x3630, 0x4a},
    {0x3631, 0x58},
    {0x3633, 0x52},
    {0x3635, 0x03},
    {0x3636, 0x25},
    {0x3637, 0x8a},
    {0x3638, 0x0f},
    {0x3639, 0x08},
    {0x363a, 0x00},
    {0x363b, 0x48},
    {0x363c, 0x86},
    {0x363e, 0xf8},
    {0x3640, 0x00},
    {0x3641, 0x01},
    {0x36ea, 0x3b},
    {0x36eb, 0x1e},
    {0x36ec, 0x0e},
    {0x36ed, 0x20},
    {0x36fa, 0x3b},
    {0x36fb, 0x30},
    {0x36fc, 0x02},
    {0x36fd, 0x00},
    {0x3908, 0x91},
    {0x391b, 0x81},
    {0x3d08, 0x01},
    {0x3e01, 0x18},
    {0x3e02, 0xf0},
    {0x3e03, 0x2b},
    {0x3e06, 0x0c},
    {0x3f04, 0x04},
    {0x3f05, 0x50},
    {0x4500, 0x59},
    {0x4501, 0xc4},
    {0x4603, 0x00},
    {0x4800, 0x64},
    {0x4809, 0x01},
    {0x4810, 0x00},
    {0x4811, 0x01},
    {0x4837, 0x28},
    {0x5011, 0x00},
    {0x5988, 0x02},
    {0x598e, 0x04},
    {0x598f, 0x54},
    {0x36e9, 0x04},
    {0x36f9, 0x04},
    // {SC035HGS_REG_SLEEP_MODE, 0x01}, // sleep dis, normal work
    {0x4418, 0x0a},
    {0x363d, 0x10},
    {0x4419, 0x80},

    // [gain<2]
    {0x3314, 0x6d},
    {0x3317, 0x13},
    {0x3631, 0x58},
    {0x3630, 0x4a},

    // [4>gain>=2]
    {0x3314, 0x56},
    {0x3317, 0x10},
    {0x3631, 0x48},
    {0x3630, 0x4c},

    // [gain>=4]
    {0x3314, 0x7c},
    {0x3317, 0x15},
    {0x3631, 0x48},
    {0x3630, 0x4c},
};

/*
 * Xclk 24Mhz
 * Pclk 45Mhz
 * linelength 683(0x2ab)
 * framelength 878(0x36e)
 * grabwindow_width 640
 * grabwindow_height 480
 * max_framerate 120fps
 * NO_HDR
 * mipi_datarate per lane 850Mbps
 */
static const sc035hgs_reginfo_t mipi_24Minput_1lane_640x480_raw10_linear_120fps[] = {
    {0x0103, 0x01},
    {SC035HGS_REG_DELAY, 0x08},
    {SC035HGS_REG_SLEEP_MODE, 0x00}, // sleep en
    {0x36e9, 0x80},
    {0x36f9, 0x80},
    {0x3000, 0x00},
    {0x3001, 0x00},
    {0x300f, 0x0f},
    {0x3018, 0x13},
    {0x3019, 0xfc},
    {0x301c, 0x78},
    {0x301f, 0x8b},
    {0x3031, 0x0a},
    {0x3037, 0x20},
    {0x303f, 0x01},
    {0x320c, 0x05},
    {0x320d, 0x54},
    {0x320e, 0x02},
    {0x320f, 0x10},
    {0x3217, 0x00},
    {0x3218, 0x00},
    {0x3220, 0x10},
    {0x3223, 0x48},
    {0x3226, 0x74},
    {0x3227, 0x07},
    {0x323b, 0x00},
    {0x3250, 0xf0},
    {0x3251, 0x02},
    {0x3252, 0x02},
    {0x3253, 0x08},
    {0x3254, 0x02},
    {0x3255, 0x07},
    {0x3304, 0x48},
    {0x3305, 0x00},
    {0x3306, 0x98},
    {0x3309, 0x50},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x18},
    {0x330f, 0x40},
    {0x3310, 0x10},
    {0x3314, 0x1e},
    {0x3315, 0x30},
    {0x3316, 0x48},
    {0x3317, 0x1b},
    {0x3329, 0x3c},
    {0x332d, 0x3c},
    {0x332f, 0x40},
    {0x3335, 0x44},
    {0x3344, 0x44},
    {0x335b, 0x80},
    {0x335f, 0x80},
    {0x3366, 0x06},
    {0x3385, 0x31},
    {0x3387, 0x39},
    {0x3389, 0x01},
    {0x33b1, 0x03},
    {0x33b2, 0x06},
    {0x33bd, 0xe0},
    {0x33bf, 0x10},
    {0x3621, 0xa4},
    {0x3622, 0x05},
    {0x3624, 0x47},
    {0x3630, 0x4a},
    {0x3631, 0x68},
    {0x3633, 0x52},
    {0x3635, 0x03},
    {0x3636, 0x25},
    {0x3637, 0x8a},
    {0x3638, 0x0f},
    {0x3639, 0x08},
    {0x363a, 0x00},
    {0x363b, 0x48},
    {0x363c, 0x86},
    {0x363e, 0xf8},
    {0x3640, 0x00},
    {0x3641, 0x01},
    {0x36ea, 0x2f},
    {0x36eb, 0x0e},
    {0x36ec, 0x0e},
    {0x36ed, 0x20},
    {0x36fa, 0x2f},
    {0x36fb, 0x10},
    {0x36fc, 0x02},
    {0x36fd, 0x00},
    {0x3908, 0x91},
    {0x391b, 0x81},
    {0x3d08, 0x01},
    {0x3e01, 0x18},
    {0x3e02, 0xf0},
    {0x3e03, 0x2b},
    {0x3e06, 0x0c},
    {0x3f04, 0x03},
    {0x3f05, 0x80},
    {0x4500, 0x59},
    {0x4501, 0xc4},
    {0x4603, 0x00},
    {0x4800, 0x64},
    {0x4809, 0x01},
    {0x4810, 0x00},
    {0x4811, 0x01},
    {0x4837, 0x18},
    {0x5011, 0x00},
    {0x5988, 0x02},
    {0x598e, 0x05},
    {0x598f, 0x17},
    {0x36e9, 0x62},
    {0x36f9, 0x62},
};

#ifdef __cplusplus
}
#endif
