## 0.8.0~1

- esp-video v0.8.x is fixed to using esp_cam_sensor v0.8.x and esp_ipa v0.2.x

## 0.8.0

- Supported enabling multiple camera sensors in menuconfig
- Supported getting sensor statistics by "ioctl"
- Supported setting sensor AE level by "ioctl"
- Supported searching and loading sensors' configuration parameters generated by JSON configuration files automatically
- Supported getting and setting LSC by "ioctl"
- Supported checking and set bayer order into ISP automatically
- Supported using Wi-Fi in web camera example
- Fixed ISP bypass mode issues
- Fixed stream breaking issue in web camera example
- Fixed UVC example reopening issue
- Fixed compiling error by fixing the tinyusb version on 0.15.0~10
- Increased TCP throughput by modifying configuration parameters
- Enabled JPEG hardware video device in UVC example by default
- Modified ESP-IDF version from v5.3 to v5.4 to support full ISP modules

## 0.7.0

- Add ISP pipeline controller
- ISP video device supports capturing statistics of sensor's outputting picture
- Apply image process algorithms(esp_ipa) for ISP
- Fix YUV encode and quantization error

### Enhancements

ISP pipeline controller and esp_ipa integrate and apply the following algorithms:

- Auto white balance
- Auto gain control
- Auto denoising control
- Auto enhancement control
- Color correction matrix

## 0.6.0~1

- Add USB video class(UVC) example
- Add video HTTP web server example
- Add setting customized camera sensor configuration example
- Fix capture stream example device path error

### Enhancements

- UVC supports output JPEG or H.264 format stream
- Video HTTP web server supports output JPEG format stream

## 0.6.0

- Add ISP video device
- Add V4L2 command VIDIOC_QUERYMENU to query the enumeration item
- Add setting/getting RGB2YUV standard
- Fix read/write control ID issues

### Enhancements

- ISP video device supports following features:
    - Red balance(red channel gain)
    - Blue balance(blue channel gain)
    - BF(bayer filter)
    - CCM(color correction matrix)
    - Sharpen
    - GAMMA
    - Demosaic
    - Brightness
    - Contrast
    - Saturation
    - Hue

- RGB2YUV encode items are as follows:
    - V4L2_YCBCR_ENC_601(V4L2_YCBCR_ENC_DEFAULT)
    - V4L2_YCBCR_ENC_709

- RGB2YUV quantization items are as follows
    - V4L2_QUANTIZATION_LIM_RANGE
    - V4L2_QUANTIZATION_FULL_RANGE(V4L2_QUANTIZATION_DEFAULT)

## 0.5.1

- Fix sensor initialization failed when bring up power
- Fix abnormal crash when setting CPU cache line size to be 128 bytes
- Fix other compiling error

## 0.5.0

- Support multiple opening and controlling video device
- DVP video device supports gray format and using external XTAL
- Add more V4L2 control IDs
- Add video buffer flag V4L2_BUF_FLAG_ERROR when the video process has an error
- Add extended command to set or get sensor format
- Bind video device to specific index name, for more details refer to README.md
- Video device drops all buffer after calling the command VIDIOC_STREAMOFF
- Fix V4L2 control value checking error
- Optimize video core API parameters checking

### Enhancements

- Added V4L2 control IDs:
    ```
    V4L2_CID_GAIN
    V4L2_CID_EXPOSURE_ABSOLUTE
    V4L2_CID_EXPOSURE
    V4L2_CID_TEST_PATTERN
    ```
- Added extended commands:
    ```
    VIDIOC_S_SENSOR_FMT
    VIDIOC_G_SENSOR_FMT
    ```

## 0.4.0

- Support H.264 hardware encode video device
- Support JPEG hardware encode video device
- CSI video device supports to receive data directly from sensor, such RGB, YUV and so on
- Add option ESP_VIDEO_DISABLE_MIPI_CSI_DRIVER_BACKUP_BUFFER to disable MIPI-CSI driver backup buffer

## 0.3.0

- Support ESP32-P4 LCD_CAM DVP video device

## 0.2.0

- Support V4L2 `V4L2_MEMORY_USERPTR`
- Fix CSI video device stop issue
- Fix I2C clock frequency can't be used when input I2C handle

## 0.1.2

- Update the API and macro to support ESP-IDF new version

## 0.1.1

- Modify API `esp_video_create` and put camera device management from video core to hardware device driver

## 0.1.0

- Initial version for esp_video component

### Enhancements

- MIPI CSI video device
- Virtual file system to control video device
- Linux V4L2 commands mainly includes(actually not support commands' full features):

```
    VIDIOC_QUERYCAP

    VIDIOC_STREAMON
    VIDIOC_STREAMOFF

    VIDIOC_ENUM_FMT
    VIDIOC_G_FMT
    VIDIOC_S_FMT

    VIDIOC_REQBUFS
    VIDIOC_QUERYBUF
    VIDIOC_QBUF
    VIDIOC_DQBUF

    VIDIOC_G_EXT_CTRLS
    VIDIOC_S_EXT_CTRLS
    VIDIOC_QUERY_EXT_CTRL
```
