/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: ESPRESSIF MIT
 */

#pragma once

#include <stdint.h>
#include "esp_cam_sensor_types.h"
#include "sc2336_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Custom register list */
static const sc2336_reginfo_t init_reglist_custom_MIPI_2lane_800x800_raw8_30fps[] = {
    {0x0103, 0x01},
    {0x0100, 0x00}, // sleep en
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0xa6},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x3200, 0x02},
    {0x3201, 0x24},
    {0x3202, 0x00},
    {0x3203, 0x8c},
    {0x3204, 0x05},
    {0x3205, 0x63},
    {0x3206, 0x03},
    {0x3207, 0xb3},
    {0x3208, 0x03},
    {0x3209, 0x20},
    {0x320a, 0x03},
    {0x320b, 0x20},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x04},
    {0x320f, 0xe2},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4d},
    {0x3e02, 0xc0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x04},
    {0x481d, 0x0c},
    {0x481f, 0x03},
    {0x4821, 0x0a},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x54},
    {0xffff, 0x00}, // end reg list
};

/* If you want to use the baseboard's ISP, provide ISP info */
static const esp_cam_sensor_isp_info_t custom_fmt_isp_info = {
    .isp_v1_info = {
        .version = SENSOR_ISP_INFO_VERSION_DEFAULT,
        .pclk = 84000000,
        .vts = 1250,
        .hts = 2240,
        .gain_def = 0,
        .exp_def = 0x4dc,
        .bayer_type = ESP_CAM_SENSOR_BAYER_BGGR,
    }
};

/*Provides the description of the initializer list.
 *Note that the description of the format must be `static const` type */
static const esp_cam_sensor_format_t custom_format_info = {
    .name = "MIPI_2lane_24Minput_RAW8_800x800_30fps",
    .format = ESP_CAM_SENSOR_PIXFORMAT_RAW8,
    .port = ESP_CAM_SENSOR_MIPI_CSI,
    .xclk = 24000000,
    .width = 800,
    .height = 800,
    .regs = init_reglist_custom_MIPI_2lane_800x800_raw8_30fps,
    .regs_size = ARRAY_SIZE(init_reglist_custom_MIPI_2lane_800x800_raw8_30fps),
    .fps = 30,
    .isp_info = &custom_fmt_isp_info,
    .mipi_info = {
        .mipi_clk = 336000000,
        .lane_num = 2,
        .line_sync_en = false,
    },
    .reserved = NULL,
};

#ifdef __cplusplus
}
#endif
