/*
 * SPDX-FileCopyrightText: 2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "sc2336_regs.h"
#include "sc2336_types.h"

#ifdef __cplusplus
extern "C" {
#endif

// cleaned_0x2d_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1280x720_25fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_720p_25fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x2d},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x34},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x53},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320c, 0x07},
    {0x320d, 0x08},
    {0x320e, 0x07},
    {0x320f, 0x08},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0x30},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x70},
    {0x3e02, 0x20},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

//cleaned_0x2e_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1280x720_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_720p_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x2e},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x34},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x53},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320c, 0x07},
    {0x320d, 0x08},
    {0x320e, 0x05},
    {0x320f, 0xdc},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0x30},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x5d},
    {0x3e02, 0x60},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

// cleaned_0x2f_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1280x720_50fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_720p_50fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x2f},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x34},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x53},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320c, 0x07},
    {0x320d, 0x08},
    {0x320e, 0x03},
    {0x320f, 0x84},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0x30},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x37},
    {0x3e02, 0xe0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

// cleaned_0x30_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1280x720_60fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_720p_60fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x30},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x34},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x53},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320c, 0x07},
    {0x320d, 0x08},
    {0x320e, 0x02},
    {0x320f, 0xee},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0x30},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x2e},
    {0x3e02, 0x80},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

//cleaned_0x02_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1920x1080_30fps -> change frame length -> 15fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_1080p_15fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x02},
    {0x3106, 0x05},
    {0x320c, 0x08},
    {0x320d, 0xca},
    {0x320e, 0x09},
    {0x320f, 0x60},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4a},
    {0x3e02, 0xa0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

//cleaned_0x29_SC2336_MIPI_24Minput_1lane_660Mbps_10bit_1920x1080_25fps
static const sc2336_reginfo_t init_reglist_MIPI_1lane_1080p_25fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x3018, 0x12},
    {0x3019, 0x0e},
    {0x301f, 0x29},
    {0x3106, 0x05},
    {0x320e, 0x04},
    {0x320f, 0xb0},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ec, 0x0c},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4a},
    {0x3e02, 0xf0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x08},
    {0x481b, 0x05},
    {0x481d, 0x12},
    {0x481f, 0x04},
    {0x4821, 0x0a},
    {0x4823, 0x04},
    {0x4825, 0x04},
    {0x4827, 0x04},
    {0x4829, 0x07},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x20},
    {0x37f9, 0x27},
    {SC2336_REG_END, 0x00},
};

//cleaned_0x28_SC2336_MIPI_24Minput_2lane_330Mbps_10bit_1920x1080_25fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_1080p_25fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x28},
    {0x3106, 0x05},
    {0x320e, 0x04},
    {0x320f, 0xb0},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4a},
    {0x3e02, 0xf0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x20},
    {0x37f9, 0x27},
    {SC2336_REG_END, 0x00},
};

//cleaned_0x02_SC2336_MIPI_24Minput_2lane_405Mbps_10bit_1920x1080_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_1080p_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x02},
    {0x3106, 0x05},
    {0x320c, 0x08},
    {0x320d, 0xca},
    {0x320e, 0x04},
    {0x320f, 0xb0},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x09},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x09},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4a},
    {0x3e02, 0xa0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x03},
    {0x481d, 0x0b},
    {0x481f, 0x03},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

// cleaned_0xa6_SC2336_MIPI_24Minput_2lane_336Mbps_8bit_800x800_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_8bit_800x800_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0xa6},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x3200, 0x02},
    {0x3201, 0x24},
    {0x3202, 0x00},
    {0x3203, 0x8c},
    {0x3204, 0x05},
    {0x3205, 0x63},
    {0x3206, 0x03},
    {0x3207, 0xb3},
    {0x3208, 0x03},
    {0x3209, 0x20},
    {0x320a, 0x03},
    {0x320b, 0x20},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x04},
    {0x320f, 0xe2},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4d},
    {0x3e02, 0xc0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x04},
    {0x481d, 0x0c},
    {0x481f, 0x03},
    {0x4821, 0x0a},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x54},
    {SC2336_REG_END, 0x00},
};

// cleaned_0xa7_SC2336_MIPI_24Minput_2lane_336Mbps_10bit_800x800_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_10bit_800x800_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0xa7},
    {0x3031, 0x0a},
    {0x3037, 0x20},
    {0x3106, 0x05},
    {0x3200, 0x02},
    {0x3201, 0x24},
    {0x3202, 0x00},
    {0x3203, 0x8c},
    {0x3204, 0x05},
    {0x3205, 0x63},
    {0x3206, 0x03},
    {0x3207, 0xb3},
    {0x3208, 0x03},
    {0x3209, 0x20},
    {0x320a, 0x03},
    {0x320b, 0x20},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x03},
    {0x320f, 0xe8},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x3e},
    {0x3e02, 0x20},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x05},
    {0x481b, 0x03},
    {0x481d, 0x09},
    {0x481f, 0x02},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x02},
    {0x4827, 0x03},
    {0x4829, 0x04},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x30},
    {SC2336_REG_END, 0x00},
};

// cleaned_0xa8_SC2336_MIPI_24Minput_2lane_210Mbps_10bit_640x480_50fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_10bit_640x480_50fps[] = {
    {0X0103, 0X01},
    {SC2336_REG_SLEEP_MODE, 0X00},
    {0X36e9, 0X80},
    {0X37f9, 0X80},
    {0X301f, 0Xa8},
    {0X3106, 0X05},
    {0X3200, 0X02},
    {0X3201, 0X74},
    {0X3202, 0X01},
    {0X3203, 0X2c},
    {0X3204, 0X05},
    {0X3205, 0X13},
    {0X3206, 0X03},
    {0X3207, 0X13},
    {0X3208, 0X02},
    {0X3209, 0X80},
    {0X320a, 0X01},
    {0X320b, 0Xe0},
    {0X320c, 0X06},
    {0X320d, 0X40},
    {0X320e, 0X02},
    {0X320f, 0X0d},
    {0X3210, 0X00},
    {0X3211, 0X10},
    {0X3212, 0X00},
    {0X3213, 0X04},
    {0X3248, 0X04},
    {0X3249, 0X0b},
    {0X3250, 0X40},
    {0X3253, 0X08},
    {0X3301, 0X09},
    {0X3302, 0Xff},
    {0X3303, 0X10},
    {0X3306, 0X60},
    {0X3307, 0X02},
    {0X330a, 0X01},
    {0X330b, 0X10},
    {0X330c, 0X16},
    {0X330d, 0Xff},
    {0X3318, 0X02},
    {0X3321, 0X0a},
    {0X3327, 0X0e},
    {0X332b, 0X12},
    {0X3333, 0X10},
    {0X3334, 0X40},
    {0X335e, 0X06},
    {0X335f, 0X0a},
    {0X3364, 0X1f},
    {0X337c, 0X02},
    {0X337d, 0X0e},
    {0X3390, 0X09},
    {0X3391, 0X0f},
    {0X3392, 0X1f},
    {0X3393, 0X20},
    {0X3394, 0X20},
    {0X3395, 0X20},
    {0X33a2, 0X04},
    {0X33b1, 0X80},
    {0X33b2, 0X68},
    {0X33b3, 0X42},
    {0X33f9, 0X78},
    {0X33fb, 0Xd0},
    {0X33fc, 0X0f},
    {0X33fd, 0X1f},
    {0X349f, 0X03},
    {0X34a6, 0X0f},
    {0X34a7, 0X1f},
    {0X34a8, 0X42},
    {0X34a9, 0X06},
    {0X34aa, 0X01},
    {0X34ab, 0X28},
    {0X34ac, 0X01},
    {0X34ad, 0X84},
    {0X3630, 0Xf4},
    {0X3633, 0X22},
    {0X3639, 0Xf4},
    {0X363c, 0X47},
    {0X3670, 0X09},
    {0X3674, 0Xf4},
    {0X3675, 0Xfb},
    {0X3676, 0Xed},
    {0X367c, 0X09},
    {0X367d, 0X0f},
    {0X3690, 0X22},
    {0X3691, 0X22},
    {0X3692, 0X22},
    {0X3698, 0X89},
    {0X3699, 0X96},
    {0X369a, 0Xd0},
    {0X369b, 0Xd0},
    {0X369c, 0X09},
    {0X369d, 0X0f},
    {0X36a2, 0X09},
    {0X36a3, 0X0f},
    {0X36a4, 0X1f},
    {0X36d0, 0X01},
    {0X36ea, 0X07},
    {0X36eb, 0X1c},
    {0X36ec, 0X1c},
    {0X36ed, 0X28},
    {0X3722, 0Xe1},
    {0X3724, 0X41},
    {0X3725, 0Xc1},
    {0X3728, 0X20},
    {0X37fa, 0X07},
    {0X37fb, 0X32},
    {0X37fc, 0X11},
    {0X37fd, 0X37},
    {0X3900, 0X0d},
    {0X3905, 0X98},
    {0X391b, 0X81},
    {0X391c, 0X10},
    {0X3933, 0X81},
    {0X3934, 0Xc5},
    {0X3940, 0X68},
    {0X3941, 0X00},
    {0X3942, 0X01},
    {0X3943, 0Xc6},
    {0X3952, 0X02},
    {0X3953, 0X0f},
    {0X3e01, 0X20},
    {0X3e02, 0X70},
    {0X3e08, 0X1f},
    {0X3e1b, 0X14},
    {0X440e, 0X02},
    {0X4509, 0X38},
    {0X4800, 0X44},
    {0X4819, 0X03},
    {0X481b, 0X02},
    {0X481d, 0X06},
    {0X481f, 0X02},
    {0X4821, 0X07},
    {0X4823, 0X02},
    {0X4825, 0X02},
    {0X4827, 0X02},
    {0X4829, 0X03},
    {0X5799, 0X06},
    {0X5ae0, 0Xfe},
    {0X5ae1, 0X40},
    {0X5ae2, 0X30},
    {0X5ae3, 0X28},
    {0X5ae4, 0X20},
    {0X5ae5, 0X30},
    {0X5ae6, 0X28},
    {0X5ae7, 0X20},
    {0X5ae8, 0X3c},
    {0X5ae9, 0X30},
    {0X5aea, 0X28},
    {0X5aeb, 0X3c},
    {0X5aec, 0X30},
    {0X5aed, 0X28},
    {0X5aee, 0Xfe},
    {0X5aef, 0X40},
    {0X5af4, 0X30},
    {0X5af5, 0X28},
    {0X5af6, 0X20},
    {0X5af7, 0X30},
    {0X5af8, 0X28},
    {0X5af9, 0X20},
    {0X5afa, 0X3c},
    {0X5afb, 0X30},
    {0X5afc, 0X28},
    {0X5afd, 0X3c},
    {0X5afe, 0X30},
    {0X5aff, 0X28},
    {0X36e9, 0X24},
    {0X37f9, 0X20},
    {SC2336_REG_END, 0x00},
};

// cleaned_0x2a_SC2336_DVP_24Minput_49.5Mpclk_10bit_1280x720_30fps
static const sc2336_reginfo_t init_reglist_DVP_720p_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x3001, 0xff},
    {0x3002, 0xf0},
    {0x300a, 0x24},
    {0x3018, 0x0f},
    {0x301a, 0xf8},
    {0x301c, 0x94},
    {0x301f, 0x2a},
    {0x3030, 0x01},
    {0x303f, 0x81},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x40},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x47},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320e, 0x02},
    {0x320f, 0xee},
    {0x3210, 0x00},
    {0x3211, 0x04},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x70},
    {0x33fb, 0xd0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x23},
    {0x34ac, 0x01},
    {0x34ad, 0x84},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3641, 0x03}, //PAD driving
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x33},
    {0x3691, 0x33},
    {0x3692, 0x43},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0b},
    {0x3000, 0xff},
    {0x36eb, 0x0c},
    {0x36ec, 0x1c},
    {0x36ed, 0x28},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0xcb},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x07},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x2e},
    {0x3e02, 0x90},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4603, 0x09},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x51},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

// cleaned_0x8e_SC2336_MIPI_24Minput_2lane_336Mbps_8bit_1920x1080_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_1080p_raw8_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x8e},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x04},
    {0x320f, 0xe2},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4d},
    {0x3e02, 0xc0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x04},
    {0x481d, 0x0c},
    {0x481f, 0x03},
    {0x4821, 0x0a},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x54},
    {SC2336_REG_END, 0x00},
};

// cleaned_0x8e_SC2336_MIPI_24Minput_2lane_336Mbps_8bit_1280x720_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_720p_raw8_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0x8e},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0x34},
    {0x3202, 0x00},
    {0x3203, 0xb4},
    {0x3204, 0x06},
    {0x3205, 0x53},
    {0x3206, 0x03},
    {0x3207, 0x8b},
    {0x3208, 0x05},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0xd0},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x04},
    {0x320f, 0xe2},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4d},
    {0x3e02, 0xc0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x04},
    {0x481d, 0x0c},
    {0x481f, 0x03},
    {0x4821, 0x0a},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x54},
    {SC2336_REG_END, 0x00},
};

// cleaned_0xa6_SC2336_MIPI_24Minput_2lane_336Mbps_8bit_800x800_30fps
static const sc2336_reginfo_t init_reglist_MIPI_2lane_800x800_raw8_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0xa6},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x3200, 0x02},
    {0x3201, 0x24},
    {0x3202, 0x00},
    {0x3203, 0x8c},
    {0x3204, 0x05},
    {0x3205, 0x63},
    {0x3206, 0x03},
    {0x3207, 0xb3},
    {0x3208, 0x03},
    {0x3209, 0x20},
    {0x320a, 0x03},
    {0x320b, 0x20},
    {0x320c, 0x08},
    {0x320d, 0xc0},
    {0x320e, 0x04},
    {0x320f, 0xe2},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x68},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x18},
    {0x330c, 0x16},
    {0x330d, 0xd3},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xe0},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x0e},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x15},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x17},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x4d},
    {0x3e02, 0xc0},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x440e, 0x02},
    {0x4509, 0x38},
    {0x4819, 0x06},
    {0x481b, 0x04},
    {0x481d, 0x0c},
    {0x481f, 0x03},
    {0x4821, 0x0a},
    {0x4823, 0x03},
    {0x4825, 0x03},
    {0x4827, 0x03},
    {0x4829, 0x05},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x54},
    {0x37f9, 0x54},
    {SC2336_REG_END, 0x00},
};

// Cleaned_0xc7_SC2336_MIPI_24Minput_2Lane_288Mbps_8bit_1024x600_30fps_20240628
static const sc2336_reginfo_t init_reglist_MIPI_2lane_1024x600_raw8_30fps[] = {
    {0x0103, 0x01},
    {SC2336_REG_SLEEP_MODE, 0x00},
    {0x36e9, 0x80},
    {0x37f9, 0x80},
    {0x301f, 0xc7},
    {0x3031, 0x08},
    {0x3037, 0x00},
    {0x3106, 0x05},
    {0x3200, 0x01},
    {0x3201, 0xb4},
    {0x3202, 0x00},
    {0x3203, 0xf0},
    {0x3204, 0x05},
    {0x3205, 0xd3},
    {0x3206, 0x03},
    {0x3207, 0x4f},
    {0x3208, 0x04},
    {0x3209, 0x00},
    {0x320a, 0x02},
    {0x320b, 0x58},
    {0x320c, 0x09},
    {0x320d, 0x60},
    {0x320e, 0x03},
    {0x320f, 0xe8},
    {0x3210, 0x00},
    {0x3211, 0x10},
    {0x3212, 0x00},
    {0x3213, 0x04},
    {0x3248, 0x04},
    {0x3249, 0x0b},
    {0x3253, 0x08},
    {0x3301, 0x09},
    {0x3302, 0xff},
    {0x3303, 0x10},
    {0x3306, 0x60},
    {0x3307, 0x02},
    {0x330a, 0x01},
    {0x330b, 0x10},
    {0x330c, 0x16},
    {0x330d, 0xff},
    {0x3318, 0x02},
    {0x3321, 0x0a},
    {0x3327, 0x0e},
    {0x332b, 0x12},
    {0x3333, 0x10},
    {0x3334, 0x40},
    {0x335e, 0x06},
    {0x335f, 0x0a},
    {0x3364, 0x1f},
    {0x337c, 0x02},
    {0x337d, 0x0e},
    {0x3390, 0x09},
    {0x3391, 0x0f},
    {0x3392, 0x1f},
    {0x3393, 0x20},
    {0x3394, 0x20},
    {0x3395, 0xff},
    {0x33a2, 0x04},
    {0x33b1, 0x80},
    {0x33b2, 0x68},
    {0x33b3, 0x42},
    {0x33f9, 0x78},
    {0x33fb, 0xd8},
    {0x33fc, 0x0f},
    {0x33fd, 0x1f},
    {0x349f, 0x03},
    {0x34a6, 0x0f},
    {0x34a7, 0x1f},
    {0x34a8, 0x42},
    {0x34a9, 0x06},
    {0x34aa, 0x01},
    {0x34ab, 0x28},
    {0x34ac, 0x01},
    {0x34ad, 0x90},
    {0x3630, 0xf4},
    {0x3633, 0x22},
    {0x3639, 0xf4},
    {0x363c, 0x47},
    {0x3670, 0x09},
    {0x3674, 0xf4},
    {0x3675, 0xfb},
    {0x3676, 0xed},
    {0x367c, 0x09},
    {0x367d, 0x0f},
    {0x3690, 0x22},
    {0x3691, 0x22},
    {0x3692, 0x22},
    {0x3698, 0x89},
    {0x3699, 0x96},
    {0x369a, 0xd0},
    {0x369b, 0xd0},
    {0x369c, 0x09},
    {0x369d, 0x0f},
    {0x36a2, 0x09},
    {0x36a3, 0x0f},
    {0x36a4, 0x1f},
    {0x36d0, 0x01},
    {0x36ea, 0x08},
    {0x36eb, 0x0a},
    {0x36ec, 0x1a},
    {0x36ed, 0x18},
    {0x3722, 0xe1},
    {0x3724, 0x41},
    {0x3725, 0xc1},
    {0x3728, 0x20},
    {0x37fa, 0x08},
    {0x37fb, 0x32},
    {0x37fc, 0x11},
    {0x37fd, 0x37},
    {0x3900, 0x0d},
    {0x3905, 0x98},
    {0x391b, 0x81},
    {0x391c, 0x10},
    {0x3933, 0x81},
    {0x3934, 0xc5},
    {0x3940, 0x68},
    {0x3941, 0x00},
    {0x3942, 0x01},
    {0x3943, 0xc6},
    {0x3952, 0x02},
    {0x3953, 0x0f},
    {0x3e01, 0x3e},
    {0x3e02, 0x20},
    {0x3e08, 0x1f},
    {0x3e1b, 0x14},
    {0x4509, 0x38},
    {0x4819, 0x05},
    {0x481b, 0x03},
    {0x481d, 0x0a},
    {0x481f, 0x02},
    {0x4821, 0x08},
    {0x4823, 0x03},
    {0x4825, 0x02},
    {0x4827, 0x03},
    {0x4829, 0x04},
    {0x5799, 0x06},
    {0x5ae0, 0xfe},
    {0x5ae1, 0x40},
    {0x5ae2, 0x30},
    {0x5ae3, 0x28},
    {0x5ae4, 0x20},
    {0x5ae5, 0x30},
    {0x5ae6, 0x28},
    {0x5ae7, 0x20},
    {0x5ae8, 0x3c},
    {0x5ae9, 0x30},
    {0x5aea, 0x28},
    {0x5aeb, 0x3c},
    {0x5aec, 0x30},
    {0x5aed, 0x28},
    {0x5aee, 0xfe},
    {0x5aef, 0x40},
    {0x5af4, 0x30},
    {0x5af5, 0x28},
    {0x5af6, 0x20},
    {0x5af7, 0x30},
    {0x5af8, 0x28},
    {0x5af9, 0x20},
    {0x5afa, 0x3c},
    {0x5afb, 0x30},
    {0x5afc, 0x28},
    {0x5afd, 0x3c},
    {0x5afe, 0x30},
    {0x5aff, 0x28},
    {0x36e9, 0x53},
    {0x37f9, 0x53},
    {SC2336_REG_END, 0x00},
};

#ifdef __cplusplus
}
#endif
